#!/usr/intel/bin/perl
#*********************************************************************
#
print "\nThe operating system is:  $^O\n";
if ($#ARGV != 0) {
   print "\nThe number of command line arguments is: ",$#ARGV+1,"\n";
   print "Usage: IVmatrix.pl 'Filename' (without the extension) \n\n";
   goto(Label_END);
   }
$LISfile = "$ARGV[0].lis";                                           # Change extension of file name to "lis"
$Mfile   = "$ARGV[0].m";                                             # Change extension of file name to "lis"
#print "$LISfile\n";                                                  # For testing only
#
#*********************************************************************
#
$Bias_count  = 0;
$Row_count   = 0;
$Found_bias  = 0;
$Found_table = 0;
$Line        = 0;

open (INPUT,  "< $LISfile") || die "Can't open $LISfile: $!";

while (<INPUT>) {
   $Line = $Line+1;
   if (($Found_bias == 0) && ($_ =~ /(parameter bias)+(\s*=\s*)+(\S*)/i)) {              # Find "parameter bias"
      $V_bias[$Bias_count] = $3;
#      print "$Line Bias_count: $Bias_count   V_bias: $V_bias[$Bias_count]\n";            # For testing only
      $Found_bias = 1;
      $Bias_count = $Bias_count + 1;
   }
   elsif (($Found_bias == 1) && ($Found_table == 0) && ($_ =~ /(freq)+(\s*c_total)+/i)) {
#      print "$Line Table header:  $1$2\n";                                               # For testing only
      $Found_table = 1;                                                                  # Find the beginning of the table
   }
   elsif (($Found_table == 1) && ($_ =~ /\s*(\S+)\s*(\S+)/i)) {
#      if ($Row_count == 0) { print "$Line Table:  '$1''$2'\n"; }                         # For testing only
      $Freq[$Row_count] = $1;                                                            # Extract numbers from table
      $Isw_p[$Row_count][$Bias_count-1] = $2;
#      if ($Row_count == 0) { print "V_bias: $V_bias[$Bias_count-1]\n"; }                 # For testing only
      $Row_count = $Row_count + 1;
   }
   elsif (($Found_table == 1) && ($_ =~ /^(y)/i)) {
      $Found_bias  = 0;
      $Found_table = 0;
      $Rows        = $Row_count;
      $Row_count   = 0;
   }
}
close (INPUT);
#
#*********************************************************************
#
open (OUTPUT1, "> $Mfile")                      || die "Can't open file: $!";
(print OUTPUT1 "echo off;\n")                   || die "Can't write to file: $!";   # Turn Matlab's Echo off

(print OUTPUT1 "Freq=[\n")                      || die "Can't write to file: $!";   # Start Matlab matrix
for ($i=0; $i < $Rows; $i++) {                                                      # Loop $Rows times
   (print OUTPUT1 "$Freq[$i]")                  || die "Can't write to file: $!";   # Print a row of numbers to file
   if ($i < $Rows-1) {(print OUTPUT1 "\n")      || die "Can't write to file: $!";}  # Start a new row in file
   else              {(print OUTPUT1 "];\n")    || die "Can't write to file: $!";}  # Finish last row with a "]"
}
#
(print OUTPUT1 "V_bias=[\n")                       || die "Can't write to file: $!";   # Start Matlab matrix
for ($i=0; $i < $Bias_count; $i++) {                                                   # Loop $Bias_count times
   (print OUTPUT1 "$V_bias[$i]")                   || die "Can't write to file: $!";   # Print a row of numbers to file
   if ($i < $Bias_count-1) {(print OUTPUT1 "\n")   || die "Can't write to file: $!";}  # Start a new row in file
   else                    {(print OUTPUT1 "];\n") || die "Can't write to file: $!";}  # Finish last row with a "]"
}
#
for ($i=0; $i < $Bias_count; $i++) {                                                # Loop $Bias_count times
   (print OUTPUT1 "C_total(:,$i+1)=[\n")        || die "Can't write to file: $!";   # Start Matlab matrix
   for ($j=0; $j < $Rows; $j++) {                                                   # Loop $Rows times
      (print OUTPUT1 "$Isw_p[$j][$i]")          || die "Can't write to file: $!";   # Print a row of numbers to file
   if ($j < $Rows-1) {(print OUTPUT1 ";\n")     || die "Can't write to file: $!";}  # Start a new row in file
   else              {(print OUTPUT1 "];\n")    || die "Can't write to file: $!";}  # Finish last row in file
   }
}
#
close (OUTPUT1);
#
#*********************************************************************
#
Label_END:
#
#*********************************************************************
